/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.io.IOException;
import java.io.Reader;
import net.loomchild.segment.srx.legacy.Buffer;
import net.loomchild.segment.util.IORuntimeException;

public class ReaderCharSequence
implements CharSequence {
    public static final int DEFAULT_BUFFER_LENGTH = 65536;
    public static final int DEFAULT_LOOKAHEAD = 1;
    public static final int INFINITE_LENGTH = 0x7FFFFFF7;
    private Reader reader;
    private int lookahead;
    private Buffer buffer;
    private int position;
    private int length;

    public ReaderCharSequence(Reader reader, int bufferLength, int length, int lookahead) {
        if (length > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Length cannot be greater than infinity (2147483639) bacause it may cause overflow (when matching regular expression for example). Use " + ReaderCharSequence.class.getName() + ".INFINITE_LENGTH constant instead.");
        }
        this.reader = reader;
        this.lookahead = lookahead;
        this.buffer = new Buffer(bufferLength);
        this.position = 0;
        this.length = length;
        this.fillBuffer(-1);
    }

    public ReaderCharSequence(Reader reader, int bufferLength, int length) {
        this(reader, bufferLength, length, 1);
    }

    public ReaderCharSequence(Reader reader, int bufferLength) {
        this(reader, bufferLength, 0x7FFFFFF7);
    }

    public ReaderCharSequence(Reader reader) {
        this(reader, 65536);
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " not in <0, " + this.length + ")");
        }
        if (index < this.getMinIndex()) {
            throw new IllegalStateException("Character lost, buffer too small.");
        }
        this.fillBuffer(index);
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("End of stream.");
        }
        int relativeIndex = this.getRelativeIndex(index);
        char character = this.buffer.charAt(relativeIndex);
        return character;
    }

    public CharSequence subSequence(int start2, int end) {
        if (start2 < 0 || end < 0 || end > this.length || start2 > end) {
            throw new IndexOutOfBoundsException("Subsequence <" + start2 + ", " + end + ") not in " + "<0, " + this.length + ").");
        }
        this.fillBuffer(end - 1);
        if (end > this.length) {
            end = this.length;
        }
        if (start2 > end) {
            throw new IndexOutOfBoundsException("Subsequence <" + start2 + ", " + end + ") not in " + "<0, " + this.length + ").");
        }
        if (end - start2 > this.buffer.length() || start2 < this.getMinIndex()) {
            throw new IllegalStateException("Cannot retrieve subsequence <" + start2 + ", " + end + "). " + "Characters lost, buffer too small.");
        }
        int relativeStart = this.getRelativeIndex(start2);
        int relativeEnd = this.getRelativeIndex(end);
        CharSequence subSequence = this.buffer.subSequence(relativeStart, relativeEnd);
        return subSequence;
    }

    private int getRelativeIndex(int index) {
        return index - (this.position - this.buffer.length());
    }

    private int getMinIndex() {
        return this.position - this.buffer.length();
    }

    private void fillBuffer(int index) {
        while (index >= this.position - this.lookahead && this.position < this.length) {
            this.readCharacter();
        }
    }

    private void readCharacter() {
        int readResult;
        try {
            readResult = this.reader.read();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (readResult == -1) {
            this.length = this.position;
        } else {
            char character = (char)readResult;
            this.buffer.forceEnqueue(character);
            ++this.position;
        }
    }
}

